.code

re_fix_calls:
    cmp     [dll_size], 172544      ; if dplayerx.dll is 172,544 bytes, calls need fixing
    je     re_fix_ok
    cmp     [dll_size], 173568      ; if dplayerx.dll is 173,568 bytes, calls need fixing
    je     re_fix_ok    
    ret
    
re_fix_ok:    
    mov esi, offset empty   ; empty is the tiny buffer, which contains pointers to each
                            ; decrypted section, or 'sections to decrypt' .. (in the pe header)
    
next_section:
    push esi
    mov esi, [esi]
    or esi, esi
    jne more_stuff_to_fix
    pop esi
    ret

more_stuff_to_fix:
    mov ebx, [esi+14h]  ; raw offset
    mov edx, [esi+10h]  ; section's RAW size
    mov [re_temp_offset], ebx
    add dword ptr [re_temp_offset], 2
rfc_size_ok:
    mov ecx, dword ptr [esi+14h]       ; section's RAW offset
    add ecx, dword ptr [memory_ptr]    ; ecx points to beginning of section
    mov esi, ecx

    add edx, ebx       ; edx == raw offset+raw size of section
    add ebx, 2
    add ecx, 2
    sub edx, 4

rfc_scan_next_byte:
    inc esi
    mov eax, esi
    sub eax, [memory_ptr]   ; eax raw offset to byte
    cmp eax, edx            ; check its lower than the size of this section
    jl  rfc_check_ff15
rfc_get_next_section:
    pop esi
    add esi, 4          ; prep esi so it points to next decrypted section
    jmp next_section

rfc_check_ff15:
    sub eax, ebx    ; eax == raw offset in section
    add ebx, eax
    add ecx, eax
    cmp word ptr [ecx-02], 15FFh    ; do we have a CALL DWORD PTR ?
    jne rfc_scan_next_byte

; decide whether or not the call needs fixing
    push edx
    push ecx
    mov eax, ebx
    sub eax, dword ptr [re_temp_offset]      ; eax == raw offset relative to section
    add eax, [decrypt_key]  ; <- code @ !text+5468 in dplayerx.dll
    xor edx, edx

    cmp [dll_size], 173568
    jne re_older_fix
    
; code for newer call fixing
    mov ecx, 4
    div ecx
    cmp edx, 3
    sbb edx,edx
    neg edx
    mov eax, edx
    pop ecx
    pop edx
    cmp eax, 1  ; was remainder of maths '1' ?
    jne rfc_scan_next_byte
    jmp decide_which_library

re_older_fix:   ;) 
    mov ecx, 3      ; dplayerx -> 00001560h ... (file offset :)
    div ecx
    mov eax, edx
    pop ecx
    pop edx
    cmp eax, 1  ; was remainder of maths '1' ?
    jne rfc_scan_next_byte


decide_which_library:
; kernel or user api to be fixed?
    mov eax, [ecx]                  ; ecx -> pointer to api .. call dword ptr [thispointer]
    sub eax, [pe_image_base]
    cmp eax, [begin_kernel_thunk]   ; was the call to a kernel api?
    jl rfc_not_kernel
    cmp eax, [end_kernel_thunk]
    ja rfc_not_kernel

; calculate the real api that it should be calling
; using decrypt_key & raw offset of call relative to the section its calling from
    sub eax, [begin_kernel_thunk]
    shr eax, 02
    push edx
    push ecx
    push eax
    mov ecx, [end_kernel_thunk]
    sub ecx, [begin_kernel_thunk]
    shr ecx, 02
    mov eax, ebx
    sub eax, dword ptr [re_temp_offset]
    add eax, [decrypt_key]
    xor edx, edx
    div ecx
    pop eax
    sub eax, edx
    xor edx, edx
    add eax, ecx
    div ecx
    mov eax, edx
    pop ecx
    pop edx
    shl eax, 02
    add eax, [begin_kernel_thunk]
    add eax, [pe_image_base]
    mov dword ptr [ecx], eax
    jmp rfc_scan_next_byte

rfc_not_kernel:

; kernel or user api to be fixed?
    cmp eax, [begin_user_thunk]    ; was the call to a user api?
    jl rfc_scan_next_byte
    cmp eax, [end_user_thunk]
    ja rfc_scan_next_byte

; calculate the real api that it should be calling
    sub eax, [begin_user_thunk]
    shr eax, 02
    push edx
    push ecx
    push eax
    mov ecx, [end_user_thunk]
    sub ecx, [begin_user_thunk]
    shr ecx, 02
    mov eax, ebx
    sub eax, dword ptr [re_temp_offset]
    add eax, [decrypt_key]
    xor edx, edx
    div ecx
    pop eax
    sub eax, edx
    xor edx, edx
    add eax, ecx
    div ecx
    mov eax, edx
    pop ecx
    pop edx
    shl eax, 02
    add eax, [begin_user_thunk]
    add eax, [pe_image_base]
    mov dword ptr [ecx], eax
    jmp rfc_scan_next_byte
